import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:get/get.dart';

import '../../../../../core/utils/my_color.dart';
import '../../../../../core/utils/style.dart';
class ProfileItemWidget extends StatelessWidget {
  final String svgImage;
  final String title;
  final VoidCallback onTap;
  const ProfileItemWidget({
    super.key, required this.svgImage, required this.title, required this.onTap,
  });

  @override
  Widget build(BuildContext context) {

    return ListTile(
      contentPadding: EdgeInsets.zero,
      leading: Container(
          padding: const EdgeInsets.all(6),
          decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(4),
              color: MyColor.primaryColor.withOpacity(.2)
          ),
          child: SvgPicture.asset(svgImage,width: 18,height: 18, colorFilter: const ColorFilter.mode(MyColor.primaryColor, BlendMode.srcIn),)
      ),
      title: Text(
        title.tr,
        style: mediumMediumLarge.copyWith(color: MyColor.bodyTextColor, fontWeight: FontWeight.normal),
      ),
      trailing: Icon(
        Icons.arrow_forward_ios,
        color: MyColor.colorBlack.withOpacity(.7),
        size: 16,
      ),
      minLeadingWidth: 10,
      onTap: onTap
    );
  }
}
